<?php
if (!defined('ABSPATH')) exit;

add_shortcode('calendario_ingressos', 'limber_render_frontend_calendar');

function limber_render_frontend_calendar() {
    // Enfileira os scripts e estilos
    wp_enqueue_style('limber-calendar-style', plugin_dir_url(__DIR__) . 'assets/style.css', [], LIMBER_CALENDAR_VERSION);
    wp_enqueue_script('limber-calendar-script', plugin_dir_url(__DIR__) . 'assets/script.js', [], LIMBER_CALENDAR_VERSION, true);

    // Busca os preços do banco de dados local
    global $wpdb;
    $hoje = date('Y-m-d');
    $resultados = $wpdb->get_results("SELECT data_visita, menor_preco FROM " . LIMBER_CALENDAR_TABLE . " WHERE data_visita >= '{$hoje}'");

    $dados_calendario = [];
    foreach ($resultados as $row) {
        $dados_calendario[$row->data_visita] = number_format($row->menor_preco, 2, ',', '.');
    }
    
    // Passa os dados para o JavaScript
    $settings = get_option('limber_settings');
    $js_data = [
        'precos'       => $dados_calendario,
        'urlIngresso'  => $settings['url_ingresso'] ?? '',
        // As cores agora são usadas apenas pelo JS, não mais no CSS diretamente
    ];
    wp_localize_script('limber-calendar-script', 'calendarioConfig', $js_data);

    // Retorna o HTML base para o JavaScript preencher
    ob_start();
    ?>
    <div id="calendario-container-wrapper">
        <div class="calendario-header">
            <span class="header-title">
                <svg fill="#fff" height="32px" width="32px" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 448 448" xml:space="preserve"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g> <path d="M160,260h-18.791l-30.616-44.532c-0.052-0.076-0.111-0.143-0.166-0.217c-0.095-0.128-0.188-0.257-0.29-0.379 c-0.094-0.113-0.196-0.218-0.295-0.325c-0.075-0.081-0.148-0.164-0.227-0.242c-0.118-0.116-0.241-0.224-0.365-0.332 c-0.07-0.061-0.139-0.125-0.211-0.184c-0.127-0.103-0.26-0.198-0.392-0.293c-0.079-0.057-0.157-0.115-0.238-0.169 c-0.126-0.083-0.255-0.158-0.384-0.233c-0.098-0.057-0.195-0.116-0.295-0.169c-0.116-0.061-0.234-0.115-0.353-0.17 c-0.121-0.056-0.241-0.113-0.365-0.164c-0.106-0.043-0.214-0.079-0.321-0.117c-0.139-0.05-0.277-0.1-0.419-0.142 c-0.105-0.031-0.211-0.055-0.317-0.081c-0.145-0.036-0.289-0.074-0.437-0.102c-0.123-0.024-0.248-0.039-0.372-0.057 c-0.131-0.019-0.26-0.041-0.393-0.053c-0.172-0.016-0.345-0.021-0.518-0.026C104.157,212.01,104.08,212,104,212h-0.065 c-0.004,0-0.009,0-0.013,0H87c-0.104,0-0.206,0.012-0.31,0.016c-0.147,0.006-0.294,0.008-0.442,0.022 c-0.167,0.016-0.329,0.043-0.493,0.068c-0.087,0.014-0.173,0.02-0.261,0.036c-0.013,0.003-0.026,0.007-0.039,0.01 c-0.19,0.037-0.374,0.086-0.559,0.137c-0.074,0.02-0.15,0.035-0.223,0.057c-0.169,0.051-0.333,0.114-0.497,0.176 c-0.086,0.032-0.175,0.06-0.26,0.095c-0.122,0.051-0.239,0.112-0.358,0.169c-0.12,0.057-0.243,0.11-0.36,0.173 c-0.064,0.035-0.124,0.076-0.187,0.112c-0.164,0.094-0.328,0.189-0.483,0.294c-0.01,0.006-0.018,0.014-0.028,0.021 c-0.417,0.284-0.805,0.604-1.157,0.957c-0.007,0.007-0.012,0.014-0.019,0.021c-0.172,0.174-0.337,0.354-0.492,0.542 c-0.096,0.116-0.182,0.24-0.272,0.362c-0.061,0.082-0.126,0.161-0.184,0.246c-0.125,0.185-0.24,0.377-0.35,0.572 c-0.015,0.027-0.034,0.053-0.049,0.08c-0.099,0.181-0.186,0.368-0.271,0.557c-0.021,0.047-0.046,0.091-0.067,0.138 c-0.063,0.146-0.113,0.298-0.167,0.448c-0.034,0.096-0.074,0.19-0.105,0.287c-0.034,0.107-0.057,0.217-0.087,0.326 c-0.04,0.147-0.083,0.294-0.114,0.444c-0.016,0.074-0.024,0.151-0.037,0.226c-0.034,0.188-0.067,0.377-0.087,0.569 c-0.006,0.061-0.007,0.124-0.012,0.186c-0.017,0.205-0.031,0.411-0.031,0.619c0,0.012-0.002,0.023-0.002,0.035 c0,0.082,0.01,0.161,0.012,0.243c0.005,0.172,0.01,0.343,0.026,0.515c0.015,0.159,0.042,0.314,0.066,0.471 c0.014,0.092,0.021,0.184,0.039,0.276l0.018,0.092c0.002,0.008,0.003,0.016,0.005,0.024L86.514,260H67.314l-13.657-13.657 c-0.053-0.053-0.112-0.099-0.166-0.15c-0.136-0.129-0.272-0.258-0.417-0.377c-0.104-0.086-0.214-0.161-0.322-0.24 c-0.102-0.076-0.202-0.155-0.308-0.226c-0.118-0.079-0.241-0.148-0.362-0.22c-0.104-0.062-0.205-0.127-0.311-0.184 c-0.118-0.063-0.24-0.117-0.36-0.174c-0.117-0.055-0.232-0.113-0.351-0.163c-0.113-0.047-0.228-0.084-0.342-0.125 c-0.132-0.048-0.263-0.099-0.399-0.14c-0.109-0.033-0.221-0.057-0.331-0.085c-0.142-0.036-0.283-0.076-0.428-0.105 c-0.121-0.024-0.244-0.038-0.366-0.056c-0.136-0.02-0.27-0.045-0.408-0.059c-0.202-0.02-0.405-0.026-0.607-0.031 C48.117,244.008,48.06,244,48,244s-0.117,0.008-0.177,0.009c-0.203,0.004-0.405,0.011-0.607,0.031 c-0.138,0.013-0.272,0.039-0.408,0.059c-0.122,0.018-0.245,0.032-0.366,0.056c-0.145,0.029-0.286,0.068-0.428,0.105 c-0.11,0.028-0.222,0.052-0.331,0.085c-0.136,0.041-0.267,0.092-0.399,0.14c-0.114,0.041-0.229,0.079-0.342,0.125 c-0.12,0.05-0.235,0.108-0.351,0.163c-0.121,0.057-0.242,0.11-0.36,0.174c-0.106,0.057-0.208,0.122-0.311,0.184 c-0.121,0.072-0.244,0.141-0.362,0.22c-0.106,0.071-0.206,0.15-0.308,0.226c-0.108,0.08-0.217,0.155-0.322,0.24 c-0.145,0.119-0.281,0.248-0.417,0.377c-0.054,0.052-0.113,0.097-0.166,0.15c-0.056,0.056-0.104,0.118-0.159,0.176 c-0.125,0.133-0.251,0.265-0.367,0.406c-0.091,0.111-0.171,0.227-0.255,0.342c-0.071,0.096-0.145,0.188-0.211,0.287 c-0.085,0.127-0.159,0.258-0.236,0.388c-0.056,0.094-0.115,0.186-0.167,0.283c-0.069,0.129-0.128,0.262-0.19,0.394 c-0.049,0.105-0.102,0.209-0.147,0.317c-0.052,0.127-0.095,0.256-0.141,0.384c-0.042,0.118-0.088,0.234-0.124,0.355 c-0.039,0.129-0.068,0.26-0.1,0.39c-0.031,0.123-0.065,0.244-0.09,0.369c-0.03,0.151-0.048,0.304-0.07,0.457 c-0.015,0.106-0.035,0.21-0.046,0.317c-0.026,0.265-0.04,0.531-0.04,0.797V284c0,0.163,0.015,0.323,0.024,0.483 c-0.143,2.216,0.625,4.48,2.318,6.174C43.905,292.219,45.952,293,48,293s4.095-0.781,5.657-2.343L68.314,276h18.199l-7.349,38.379 c-0.002,0.008-0.003,0.016-0.005,0.024l-0.018,0.092c-0.018,0.092-0.024,0.184-0.039,0.276c-0.024,0.156-0.051,0.312-0.066,0.471 c-0.017,0.173-0.021,0.344-0.026,0.515C79.01,315.839,79,315.918,79,316c0,0.012,0.002,0.023,0.002,0.035 c0.001,0.208,0.015,0.414,0.031,0.619c0.005,0.062,0.005,0.125,0.012,0.186c0.02,0.192,0.053,0.38,0.087,0.569 c0.013,0.075,0.021,0.152,0.037,0.226c0.031,0.15,0.074,0.296,0.114,0.444c0.029,0.109,0.053,0.219,0.087,0.326 c0.031,0.097,0.071,0.191,0.105,0.287c0.054,0.15,0.104,0.302,0.167,0.448c0.02,0.047,0.046,0.092,0.067,0.138 c0.085,0.189,0.172,0.376,0.271,0.557c0.015,0.028,0.033,0.053,0.049,0.08c0.11,0.195,0.224,0.388,0.35,0.572 c0.057,0.085,0.123,0.163,0.184,0.246c0.09,0.122,0.176,0.246,0.272,0.362c0.155,0.188,0.32,0.368,0.492,0.542 c0.006,0.007,0.012,0.014,0.019,0.021c0.352,0.353,0.74,0.673,1.157,0.957c0.01,0.007,0.018,0.014,0.028,0.021 c0.156,0.105,0.319,0.199,0.483,0.294c0.063,0.036,0.123,0.077,0.187,0.112c0.117,0.063,0.24,0.116,0.36,0.173 c0.119,0.057,0.236,0.118,0.358,0.169c0.085,0.035,0.174,0.063,0.26,0.095c0.164,0.062,0.328,0.125,0.497,0.176 c0.073,0.022,0.149,0.037,0.223,0.057c0.185,0.05,0.369,0.099,0.559,0.137c0.013,0.003,0.026,0.007,0.039,0.01 c0.121,0.023,0.241,0.034,0.361,0.052c0.12,0.017,0.239,0.04,0.361,0.052c0.265,0.027,0.53,0.042,0.792,0.042 c0.015,0,0.029-0.002,0.044-0.002h16.927c0.004,0,0.009,0.001,0.013,0.001c0.024,0,0.047-0.004,0.071-0.004 c0.279-0.002,0.555-0.019,0.827-0.049c0.08-0.009,0.158-0.025,0.237-0.036c0.221-0.031,0.44-0.069,0.655-0.118 c0.085-0.019,0.169-0.043,0.254-0.065c0.208-0.055,0.412-0.116,0.613-0.187c0.086-0.03,0.171-0.061,0.256-0.094 c0.201-0.078,0.396-0.166,0.588-0.259c0.078-0.038,0.157-0.072,0.234-0.113c0.256-0.135,0.506-0.281,0.745-0.442 c0.052-0.035,0.099-0.076,0.15-0.112c0.188-0.134,0.371-0.273,0.547-0.422c0.086-0.073,0.168-0.152,0.252-0.229 c0.142-0.131,0.278-0.266,0.41-0.407c0.074-0.08,0.148-0.159,0.22-0.242c0.163-0.189,0.317-0.386,0.462-0.59 c0.025-0.035,0.054-0.064,0.078-0.099L141.209,276H160c4.418,0,8-3.582,8-8S164.418,260,160,260z M96.677,228h3.114l22,32h-18.986 L96.677,228z M121.791,276l-22,32h-3.114l6.128-32H121.791z"></path> <path d="M272,300h-64c-4.418,0-8,3.582-8,8s3.582,8,8,8h64c4.418,0,8-3.582,8-8S276.418,300,272,300z"></path> <path d="M272,260h-64c-4.418,0-8,3.582-8,8s3.582,8,8,8h64c4.418,0,8-3.582,8-8S276.418,260,272,260z"></path> <path d="M208,236h64c4.418,0,8-3.582,8-8s-3.582-8-8-8h-64c-4.418,0-8,3.582-8,8S203.582,236,208,236z"></path> <path d="M360,252c-4.418,0-8,3.582-8,8v56c0,4.418,3.582,8,8,8s8-3.582,8-8v-56C368,255.582,364.418,252,360,252z"></path> <path d="M360,212c-4.418,0-8,3.582-8,8v8c0,4.418,3.582,8,8,8s8-3.582,8-8v-8C368,215.582,364.418,212,360,212z"></path> <path d="M408,84H72c-22.056,0-40,17.944-40,40v48.805C13.765,176.522,0,192.683,0,212v112c0,22.056,17.944,40,40,40h336 c22.056,0,40-17.944,40-40v-48.805c18.235-3.717,32-19.878,32-39.195V124C448,101.944,430.056,84,408,84z M16,324V212 c0-13.233,10.767-24,24-24h128.99c0.005,0,0.011,0.001,0.016,0.001c0.004,0,0.009-0.001,0.013-0.001H312v160H40 C26.767,348,16,337.233,16,324z M128.677,140h3.114l22,32h-18.986L128.677,140z M400,324c0,13.233-10.767,24-24,24h-48V188h48 c13.233,0,24,10.767,24,24V324z M432,236c0,10.429-6.689,19.321-16,22.624V212c0-13.058-6.291-24.673-16-31.978V172 c0-4.418-3.582-8-8-8s-8,3.582-8,8v0.805c-2.586-0.527-5.261-0.805-8-0.805H173.209l-30.616-44.532 c-0.052-0.075-0.111-0.142-0.164-0.215c-0.095-0.129-0.189-0.259-0.292-0.381c-0.093-0.111-0.192-0.214-0.29-0.319 c-0.078-0.083-0.152-0.169-0.233-0.248c-0.115-0.113-0.235-0.218-0.356-0.323c-0.074-0.064-0.145-0.131-0.221-0.193 c-0.124-0.1-0.252-0.193-0.381-0.285c-0.083-0.06-0.165-0.121-0.25-0.178c-0.121-0.08-0.246-0.153-0.371-0.226 c-0.102-0.06-0.204-0.121-0.309-0.177c-0.111-0.058-0.225-0.11-0.339-0.163c-0.125-0.059-0.25-0.118-0.378-0.17 c-0.101-0.041-0.204-0.075-0.306-0.112c-0.144-0.052-0.287-0.104-0.435-0.147c-0.099-0.029-0.198-0.051-0.298-0.077 c-0.151-0.038-0.301-0.077-0.455-0.107c-0.116-0.022-0.234-0.036-0.351-0.054c-0.137-0.02-0.274-0.043-0.413-0.056 c-0.164-0.016-0.328-0.019-0.492-0.025C136.172,124.01,136.088,124,136,124h-0.071c-0.001,0-0.002,0-0.003,0H119 c-0.105,0-0.206,0.012-0.31,0.016c-0.147,0.006-0.293,0.008-0.441,0.022c-0.167,0.016-0.33,0.043-0.494,0.068 c-0.087,0.014-0.173,0.02-0.26,0.036c-0.013,0.003-0.026,0.007-0.039,0.01c-0.19,0.037-0.374,0.086-0.559,0.137 c-0.074,0.02-0.15,0.035-0.223,0.057c-0.169,0.051-0.333,0.114-0.497,0.176c-0.086,0.032-0.175,0.06-0.26,0.095 c-0.122,0.051-0.239,0.112-0.358,0.169c-0.12,0.057-0.243,0.11-0.36,0.173c-0.064,0.035-0.124,0.076-0.187,0.112 c-0.164,0.094-0.328,0.189-0.483,0.294c-0.01,0.006-0.018,0.014-0.028,0.021c-0.417,0.284-0.805,0.604-1.157,0.957 c-0.007,0.007-0.012,0.014-0.019,0.021c-0.172,0.174-0.337,0.354-0.492,0.542c-0.096,0.116-0.182,0.24-0.272,0.362 c-0.061,0.082-0.126,0.161-0.184,0.246c-0.125,0.185-0.24,0.377-0.35,0.572c-0.015,0.027-0.034,0.053-0.049,0.08 c-0.099,0.181-0.186,0.368-0.271,0.557c-0.021,0.047-0.046,0.091-0.067,0.138c-0.063,0.146-0.113,0.298-0.167,0.448 c-0.034,0.096-0.074,0.19-0.105,0.287c-0.034,0.107-0.057,0.217-0.087,0.326c-0.04,0.147-0.083,0.294-0.114,0.444 c-0.016,0.074-0.024,0.151-0.037,0.226c-0.034,0.188-0.067,0.377-0.087,0.569c-0.006,0.061-0.007,0.124-0.012,0.186 c-0.017,0.205-0.031,0.411-0.031,0.619c0,0.012-0.002,0.023-0.002,0.035c0,0.082,0.01,0.161,0.012,0.243 c0.005,0.172,0.01,0.343,0.026,0.515c0.015,0.159,0.042,0.314,0.066,0.471c0.014,0.092,0.021,0.184,0.039,0.276l0.018,0.092 c0.002,0.008,0.003,0.016,0.005,0.024L118.514,172H99.314l-13.657-13.657c-0.053-0.053-0.112-0.099-0.166-0.15 c-0.136-0.129-0.272-0.258-0.417-0.377c-0.104-0.086-0.214-0.161-0.322-0.24c-0.102-0.076-0.202-0.155-0.308-0.226 c-0.118-0.079-0.241-0.148-0.362-0.22c-0.104-0.062-0.205-0.127-0.311-0.184c-0.118-0.063-0.24-0.117-0.36-0.174 c-0.117-0.055-0.232-0.113-0.351-0.163c-0.113-0.047-0.228-0.084-0.342-0.125c-0.132-0.048-0.263-0.099-0.399-0.14 c-0.109-0.033-0.221-0.057-0.331-0.085c-0.142-0.036-0.283-0.076-0.428-0.105c-0.121-0.024-0.244-0.038-0.366-0.056 c-0.136-0.02-0.27-0.045-0.408-0.059c-0.202-0.02-0.405-0.026-0.607-0.031C80.117,156.008,80.06,156,80,156 s-0.117,0.008-0.177,0.009c-0.203,0.004-0.405,0.011-0.607,0.031c-0.138,0.013-0.272,0.039-0.408,0.059 c-0.122,0.018-0.245,0.032-0.366,0.056c-0.145,0.029-0.286,0.068-0.428,0.105c-0.11,0.028-0.222,0.052-0.331,0.085 c-0.136,0.041-0.267,0.092-0.399,0.14c-0.114,0.041-0.229,0.079-0.342,0.125c-0.12,0.05-0.235,0.108-0.351,0.163 c-0.121,0.057-0.242,0.11-0.36,0.174c-0.106,0.057-0.208,0.122-0.311,0.184c-0.121,0.072-0.244,0.141-0.362,0.22 c-0.106,0.071-0.206,0.15-0.308,0.226c-0.108,0.08-0.217,0.155-0.322,0.24c-0.145,0.119-0.281,0.248-0.417,0.377 c-0.054,0.052-0.113,0.097-0.166,0.15c-0.056,0.056-0.104,0.118-0.159,0.176c-0.125,0.133-0.251,0.265-0.367,0.406 c-0.091,0.111-0.171,0.227-0.255,0.342c-0.071,0.096-0.145,0.188-0.211,0.287c-0.085,0.127-0.159,0.258-0.236,0.388 c-0.056,0.094-0.115,0.186-0.167,0.283c-0.069,0.129-0.128,0.262-0.19,0.394c-0.049,0.105-0.102,0.209-0.147,0.317 c-0.052,0.127-0.095,0.256-0.141,0.384c-0.042,0.118-0.088,0.234-0.124,0.355c-0.039,0.129-0.068,0.26-0.1,0.39 c-0.031,0.123-0.065,0.244-0.09,0.369c-0.03,0.151-0.048,0.304-0.07,0.457c-0.015,0.106-0.035,0.21-0.046,0.317 c-0.026,0.265-0.04,0.531-0.04,0.797V172H48v-48c0-13.233,10.767-24,24-24h272v48c0,4.418,3.582,8,8,8s8-3.582,8-8v-48h48 c13.233,0,24,10.767,24,24V236z"></path> <path d="M304,132h-64c-4.418,0-8,3.582-8,8s3.582,8,8,8h64c4.418,0,8-3.582,8-8S308.418,132,304,132z"></path> <path d="M392,124c-4.418,0-8,3.582-8,8v8c0,4.418,3.582,8,8,8s8-3.582,8-8v-8C400,127.582,396.418,124,392,124z"></path> </g> </g></svg>
                Escolha sua melhor data
            </span>
            <div class="month-selector">
                <button class="nav-btn" id="prev-month">&lt;</button>
                <h2 id="current-month"></h2>
                <button class="nav-btn" id="next-month">&gt;</button>
            </div>
        </div>
        <div class="calendario-body">
            <div class="weekdays">
                <div>Dom</div><div>Seg</div><div>Ter</div><div>Qua</div><div>Qui</div><div>Sex</div><div>Sáb</div>
            </div>
            <div class="days" id="calendar-days"></div>
        </div>
        <div class="calendario-footer-info">
            <svg viewBox="0 0 512 512" width="16" height="16" fill="currentColor"><path d="M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.3-208-208S141.3 48 256 48s208 93.3 208 208S370.7 464 256 464zM232 120V256c0 13.3 10.7 24 24 24h120c13.3 0 24-10.7 24-24s-10.7-24-24-24h-96V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z"/></svg>
            Parque aberto das <strong>10h às 17h</strong>, exceto às quartas-feiras.
        </div>
    </div>
    <?php
    return ob_get_clean();
}