<?php
/**
 * Plugin Name: Calendário Limber
 * Description: Calendário de ingressos com cache local e sincronização automática via API Limber.
 * Version: 1.0.0
 * Author: Seja Sparky
 */

if (!defined('ABSPATH')) exit;

define('LIMBER_CALENDAR_VERSION', '1.0.0');
define('LIMBER_CALENDAR_TABLE', $GLOBALS['wpdb']->prefix . 'limber_precos');

// Inclui os arquivos com a lógica separada
require_once plugin_dir_path(__FILE__) . 'includes/admin-settings.php';
require_once plugin_dir_path(__FILE__) . 'includes/cron-sync.php';
require_once plugin_dir_path(__FILE__) . 'includes/frontend-shortcode.php';

/**
 * Função executada na ativação do plugin.
 */
function limber_calendar_activate() {
    // Cria a tabela no banco de dados para o cache de preços
    global $wpdb;
    $charset_collate = $wpdb->get_charset_collate();
    $sql = "CREATE TABLE " . LIMBER_CALENDAR_TABLE . " (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        data_visita DATE NOT NULL,
        menor_preco DECIMAL(10,2) NOT NULL,
        atualizado_em DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY  (id),
        UNIQUE KEY data_visita_unique (data_visita)
    ) $charset_collate;";
    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);

    // Agenda o evento de sincronização diária, se ainda não estiver agendado
    if (!wp_next_scheduled('limber_sync_precos_event')) {
        wp_schedule_event(time(), 'daily', 'limber_sync_precos_event');
    }
}
register_activation_hook(__FILE__, 'limber_calendar_activate');

/**
 * Função executada na desativação do plugin.
 */
function limber_calendar_deactivate() {
    // Remove o agendamento do cron para não deixar lixo no sistema
    $timestamp = wp_next_scheduled('limber_sync_precos_event');
    if ($timestamp) {
        wp_unschedule_event($timestamp, 'limber_sync_precos_event');
    }
}
register_deactivation_hook(__FILE__, 'limber_calendar_deactivate');