<?php
/**
 * Plugin Name: Calendário de Ingressos Dinâmico
 * Description: Adiciona um calendário interativo com preços via API Limber. Use o shortcode [calendario_ingressos].
 * Version: 11.1 (Final HTML Fix)
 * Author: Seu Nome
 */

if (!defined('ABSPATH')) exit;

// =================================================================
// 1. CARREGAR SCRIPTS E ESTILOS
// =================================================================
function ci_carregar_scripts() {
    wp_enqueue_style('ci-style', plugin_dir_url(__FILE__) . 'assets/style.css', [], '11.1');
    wp_enqueue_script('ci-script', plugin_dir_url(__FILE__) . 'assets/script.js', [], '11.1', true);

    $options = get_option('ci_settings');
    $config_data = [
        'apiUrl'      => home_url('/wp-json/calendario/v1/preco/'),
        'urlIngresso' => $options['url_ingresso'] ?? '',
        'corPrincipal' => $options['cor_principal'] ?? '#d93a54',
        'corPrecos'    => $options['cor_precos'] ?? '#4ac9e1',
    ];
    wp_localize_script('ci-script', 'calendarioConfig', $config_data);
}
add_action('wp_enqueue_scripts', 'ci_carregar_scripts');

// =================================================================
// 2. LÓGICA DA API LIMBER (sem alterações)
// =================================================================
add_action('rest_api_init', function () {
    register_rest_route('calendario/v1', '/preco/(?P<data>[0-9]{4}-[0-9]{2}-[0-9]{2})', [
        'methods'  => 'GET', 'callback' => 'ci_get_preco_para_dia', 'permission_callback' => '__return_true'
    ]);
});
function ci_get_limber_token() {
    $token = get_transient('limber_api_token');
    if ($token) return $token;
    $options = get_option('ci_settings');
    $usuario = $options['limber_usuario'] ?? '';
    $senha = $options['limber_senha'] ?? '';
    if (!$usuario || !$senha) return new WP_Error('no_credentials', 'Credenciais da API não configuradas.');
    $response = wp_remote_post('https://card.limbersoftware.com.br/api/auth', [
        'headers' => ['Content-Type' => 'application/json'], 'body' => json_encode(['usuario' => $usuario, 'senha' => $senha]), 'timeout' => 20
    ]);
    if (is_wp_error($response) || wp_remote_retrieve_response_code($response) !== 200) return new WP_Error('login_failed', 'Falha na autenticação.');
    $body = json_decode(wp_remote_retrieve_body($response), true);
    $token = $body['token'] ?? null;
    if ($token) {
        set_transient('limber_api_token', $token, 6 * DAY_IN_SECONDS);
        return $token;
    }
    return new WP_Error('token_not_found', 'Token não encontrado.');
}
function ci_get_preco_para_dia($request) {
    $token = ci_get_limber_token();
    if (is_wp_error($token)) return $token;
    $options = get_option('ci_settings');
    $data_str = $request['data'];
    $params = [ 'sku' => (int) ($options['limber_sku'] ?? 0), 'idparceiro' => (int) ($options['limber_id_parceiro'] ?? 0), 'receita' => (int) ($options['limber_receita'] ?? 0), 'data' => $data_str . 'T00:00:00', 'dataFim' => $data_str . 'T23:59:59' ];
    $preco_response = wp_remote_post('https://card.limbersoftware.com.br/api/cross/consulta/configpreco', [
        'headers' => ['Authorization' => 'Bearer ' . $token, 'Content-Type'  => 'application/json'], 'body' => json_encode($params),
    ]);
    if (is_wp_error($preco_response)) return new WP_Error('api_error', 'Erro de conexão.');
    $configs_preco = json_decode(wp_remote_retrieve_body($preco_response), true);
    if (!is_array($configs_preco) || isset($configs_preco['message']) || empty($configs_preco)) return new WP_Error('no_price', 'Sem preço.', ['status' => 404]);
    $primeira_config = $configs_preco[0] ?? null;
    $categorias = $primeira_config['configPreco']['categorias'] ?? [];
    if (empty($categorias)) return new WP_Error('no_categories', 'Sem categorias.', ['status' => 404]);
    $menor_preco = PHP_FLOAT_MAX;
    foreach ($categorias as $categoria) {
        if (isset($categoria['valorUnitario']) && $categoria['valorUnitario'] < $menor_preco) $menor_preco = $categoria['valorUnitario'];
    }
    if ($menor_preco === PHP_FLOAT_MAX) return new WP_Error('no_value', 'Nenhum valor.', ['status' => 404]);
    return new WP_REST_Response(['preco' => number_format($menor_preco, 2, ',', '.')], 200);
}

// =================================================================
// 3. SHORTCODE E PÁGINA DE CONFIGURAÇÕES
// =================================================================

// ===== FUNÇÃO DO SHORTCODE CORRIGIDA =====
function ci_renderizar_calendario_shortcode() {
    // Este HTML contém todos os IDs que o JavaScript precisa para funcionar.
    return '
    <div id="calendario-container-wrapper">
        <div id="calendario-container">
            <div class="calendario-loading">Carregando Calendário...</div>
        </div>
        <div class="calendario-footer">
            <p id="dia-selecionado-texto">Nenhuma data selecionada</p>
            <a href="#" id="comprar-ingresso-btn" class="disabled">
                Comprar Ingresso
            </a>
        </div>
    </div>
    ';
}
add_shortcode('calendario_ingressos', 'ci_renderizar_calendario_shortcode');

// (O restante do código de configurações não precisa de alteração)
add_action('admin_menu', function() { /* ... */ });
add_action('admin_init', function() { /* ... */ });
function ci_render_field($args) { /* ... */ }
function ci_settings_page_html() { /* ... */ }